<?php
// vencimentos.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

$dbPath = __DIR__ . '/api/max.db';
try {
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log("Database connection error: " . $e->getMessage());
    die("❌ Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Buscar ativações que vencerão em até 3 dias
$query = "SELECT *, 
          julianday(expiration_date) - julianday('now') as dias_restantes 
          FROM activations 
          WHERE status = 'active' 
          AND expiration_date BETWEEN date('now') AND date('now', '+3 days')
          ORDER BY expiration_date ASC";
$vencimentos = $db->query($query)->fetchAll(PDO::FETCH_ASSOC);

$page_title = "📅 Ativações Próximas do Vencimento";

$page_content = '
<div class="card">
    <div class="card-header border-0 pt-6">
        <div class="card-title">
            <h2 class="fw-bold">📅 Ativações que vencem em até 3 dias</h2>
        </div>
    </div>
    <div class="card-body pt-0">
        <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-scrolling: touch;">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="vencimentos_table" style="width: 100%; min-width: 800px;">
                <thead>
                    <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                        <th class="min-w-150px">👤 Usuário</th>
                        <th class="min-w-150px">📱 WhatsApp</th>
                        <th class="min-w-100px">🔑 Código</th>
                        <th class="min-w-120px">⏳ Dias Restantes</th>
                        <th class="min-w-120px">📅 Data Expiração</th>
                        <th class="min-w-150px">📱 Dispositivo</th>
                        <th class="min-w-150px">💬 Ações</th>
                    </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
';

foreach ($vencimentos as $vencimento) {
    $dias_restantes = floor($vencimento['dias_restantes']);
    $status_class = $dias_restantes <= 1 ? 'badge-light-danger' : 'badge-light-warning';
    $expiration_date = date('d/m/Y', strtotime($vencimento['expiration_date']));
    
    $page_content .= "<tr>
        <td>{$vencimento['user']}</td>
        <td>{$vencimento['whatsapp']}</td>
        <td>{$vencimento['code']}</td>
        <td><span class='badge {$status_class}'>{$dias_restantes} dia(s)</span></td>
        <td>{$expiration_date}</td>
        <td>{$vencimento['id_dispositivo']}</td>
        <td>
            <button class='btn btn-sm btn-success' onclick=\"enviarNotificacao('{$vencimento['user']}', '{$vencimento['whatsapp']}', '{$vencimento['code']}', '{$expiration_date}', {$dias_restantes})\">
                💬 Enviar Lembrete
            </button>
        </td>
    </tr>";
}

$page_content .= '
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="whatsapp_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="fw-bold">💬 Mensagem WhatsApp</h2>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-5">
                    <label class="form-label">Para:</label>
                    <input type="text" class="form-control" id="whatsapp_destinatario" readonly>
                </div>
                <div class="mb-5">
                    <label class="form-label">Mensagem:</label>
                    <textarea class="form-control" id="whatsapp_mensagem" rows="5"></textarea>
                </div>
                <div class="alert alert-info">
                    <strong>Dica:</strong> A mensagem será aberta no WhatsApp Web/App com o texto pré-preenchido.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">❌ Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="abrirWhatsApp()">📱 Abrir WhatsApp</button>
            </div>
        </div>
    </div>
</div>
';

$page_content .= '
<script>
function enviarNotificacao(user, whatsapp, codigo, expiracao, dias) {
    // Formatar número (remover caracteres não numéricos)
    const numero = whatsapp.replace(/[^\d]/g, "");
    
    // Criar mensagem personalizada
    let mensagem = `Olá ${user}!\\n\\n`;
    mensagem += `Este é um lembrete sobre sua TV Box (Código: ${codigo}).\\n\\n`;
    mensagem += `*Sua assinatura vencerá em ${dias} dia(s)* (${expiracao}).\\n\\n`;
    mensagem += `Para renovar sua assinatura e evitar o bloqueio do serviço, entre em contato conosco.\\n\\n`;
    mensagem += `Atenciosamente,\\nSua Equipe de Suporte`;
    
    // Preencher modal
    document.getElementById("whatsapp_destinatario").value = `${user} (${whatsapp})`;
    document.getElementById("whatsapp_mensagem").value = mensagem;
    
    // Armazenar número para uso posterior
    document.getElementById("whatsapp_modal").dataset.numero = numero;
    
    // Mostrar modal
    $("#whatsapp_modal").modal("show");
}

function abrirWhatsApp() {
    const numero = document.getElementById("whatsapp_modal").dataset.numero;
    const mensagem = encodeURIComponent(document.getElementById("whatsapp_mensagem").value);
    
    // Abrir WhatsApp
    window.open(`https://wa.me/${numero}?text=${mensagem}`, "_blank");
    
    // Fechar modal
    $("#whatsapp_modal").modal("hide");
}

function enviarTodasNotificacoes() {
    Swal.fire({
        title: "⚠️ Confirmar Envio",
        text: "Você deseja enviar notificações para TODOS os clientes listados?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Sim, enviar tudo!",
        cancelButtonText: "Cancelar"
    }).then((result) => {
        if (result.isConfirmed) {
            const linhas = document.querySelectorAll("#vencimentos_table tbody tr");
            let enviados = 0;
            
            linhas.forEach((linha, index) => {
                setTimeout(() => {
                    const celulas = linha.querySelectorAll("td");
                    const user = celulas[0].textContent;
                    const whatsapp = celulas[1].textContent.replace(/[^\d]/g, "");
                    const codigo = celulas[2].textContent;
                    const expiracao = celulas[4].textContent;
                    const dias = parseInt(celulas[3].querySelector("span").textContent);
                    
                    // Criar mensagem (igual à função individual)
                    let mensagem = `Olá ${user}!\\n\\n`;
                    mensagem += `Este é um lembrete sobre sua TV Box (Código: ${codigo}).\\n\\n`;
                    mensagem += `*Sua assinatura vencerá em ${dias} dia(s)* (${expiracao}).\\n\\n`;
                    mensagem += `Para renovar sua assinatura e evitar o bloqueio do serviço, entre em contato conosco.\\n\\n`;
                    mensagem += `Atenciosamente,\\nSua Equipe de Suporte`;
                    
                    // Abrir WhatsApp (em nova aba)
                    setTimeout(() => {
                        window.open(`https://wa.me/${whatsapp}?text=${encodeURIComponent(mensagem)}`, "_blank");
                        enviados++;
                        
                        // Feedback ao finalizar
                        if (enviados === linhas.length) {
                            Swal.fire(
                                "✅ Concluído!",
                                `Notificações enviadas para ${enviados} clientes.`,
                                "success"
                            );
                        }
                    }, index * 2000); // Delay de 2s entre cada envio
                }, 0);
            });
        }
    });
}
</script>
';

include 'includes/layout.php';
?>